{$mode delphi}

uses windows,variants,sysutils,activex,comobj,wmiutil,strutils;

procedure DumpProperties(obj : OleVariant;condense : boolean=true);
var
  objprop  : OLEVariant;
  propiter : oEnumIterator;
  s        : string;
begin
   for objprop in propiter.Enumerate(obj.Properties_) do
      begin
        s:=OleVariantToText(objprop.Value);
        if (s<>'') or not condense then
           Writeln(padright(objprop.Name,40),' = ',s);
      end;
end;

// The Win32_DesktopMonitor class represents the type of monitor or display device
// attached to the computer system.

procedure  GetWin32_DesktopMonitorInfo;
const
  WbemUser            ='';
  WbemPassword        ='';
  WbemComputer        ='localhost';
  wbemFlagForwardOnly = $00000020;
var
  FSWbemLocator : OLEVariant;
  FWMIService   : OLEVariant;
  FWbemObjectSet: OLEVariant;
  obj           : OLEVariant;
  oEnum         : oEnumIterator;
begin;
  FSWbemLocator := CreateOleObject('WbemScripting.SWbemLocator');
  FWMIService   := FSWbemLocator.ConnectServer(WbemComputer, 'root\CIMV2', WbemUser, WbemPassword);
  FWbemObjectSet:= FWMIService.ExecQuery('SELECT * FROM Win32_DesktopMonitor','WQL',wbemFlagForwardOnly);

  for obj in oEnum.Enumerate(FWbemObjectSet) do
    begin
      writeln;
      DumpProperties(obj);
    end;

end;

// Monitor ID

procedure  GetWmiMonitorIDInfo;
const
  WbemUser            ='';
  WbemPassword        ='';
  WbemComputer        ='localhost';
  wbemFlagForwardOnly = $00000020;
var
  FSWbemLocator : OLEVariant;
  FWMIService   : OLEVariant;
  FWbemObjectSet: OLEVariant;
  obj           : OLEVariant;
  oEnum         : oEnumIterator;

begin;
  FSWbemLocator := CreateOleObject('WbemScripting.SWbemLocator');
  FWMIService   := FSWbemLocator.ConnectServer(WbemComputer, 'root\WMI', WbemUser, WbemPassword);
  FWbemObjectSet:= FWMIService.ExecQuery('SELECT * FROM WmiMonitorID','WQL',wbemFlagForwardOnly);
  for obj in oEnum.Enumerate(FWbemObjectSet) do
    begin
      writeln;
      DumpProperties(obj);
    end;
end;

//http://japrogbits.blogspot.com/2010/03/using-wmi-to-query-monitor-information.html
procedure  GetWin32_PnPEntityInfo;
const
  WbemUser            ='';
  WbemPassword        ='';
  WbemComputer        ='localhost';
  wbemFlagForwardOnly = $00000020;
var
  FSWbemLocator : OLEVariant;
  FWMIService   : OLEVariant;
  FWbemObjectSet: OLEVariant;
  obj           : OLEVariant;
  listiter      : oEnumIterator;
begin;
  FSWbemLocator := CreateOleObject('WbemScripting.SWbemLocator');
  FWMIService   := FSWbemLocator.ConnectServer(WbemComputer, 'root\CIMV2', WbemUser, WbemPassword);
  FWbemObjectSet:= FWMIService.ExecQuery('SELECT * FROM Win32_PnPEntity','WQL',wbemFlagForwardOnly);

  for obj in listiter.Enumerate(FWbemObjectset) do
    if obj.ConfigManagerErrorCode=0 then
       begin
         if startstext('DISPLAY',uppercase(obj.DeviceID)) then
            begin
               Writeln;
               Writeln(Format('DeviceID                  %s',[String(obj.DeviceID)]));// String
               DumpProperties(obj);
            end;
       end;
end;

begin
 // freepascal does coinitialize() in comobj
 try
    {$ifndef fpc}CoInitialize(nil);
    try
    {$endif}
      writeln('desktopinfo:');
      GetWin32_DesktopMonitorInfo;
      writeln('---');
      writeln('idinfo:');
      GetWmiMonitorIDInfo;
      writeln('---');
      writeln('pnpentity info.');
      GetWin32_PnPEntityInfo
    {$ifndef fpc}
    finally
      CoUninitialize;
    end;
    {$endif}
 except
    on E:EOleException do
        Writeln(Format('EOleException %s %x', [E.Message,E.ErrorCode]));
    on E:Exception do
        Writeln(E.Classname, ':', E.Message);
 end;
 {$ifndef fpc}
 if DebugHook=1 then
 {$endif}
   Readln;
end.