{
    $Id: dxe.pp,v 1.3 2000/12/16 15:57:52 Marco Exp $
    This file is part of the Free Pascal run time library.
    Conversion copyright (c) 1999-2000 by Pierre Muller,
    member of the Free Pascal development team.

    Reworked DXE Unit that adds unloading DXE files for Go32V2.
    (Or for COFF actually, there is no special Go32V2 requirement?)

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************
}


Unit dxe;
interface

const
   DXE_MAGIC  = $31455844;
type
  dxe_header = record
     magic,
     symbol_offset,
     element_size,
     nrelocs       : Cardinal;
  end;

  DXEHandle = Pointer;  {Opaque'ish}

function  LoadDXE      (filename : string) : DXEHandle;
function  GetDXEsymbol (handle:DXEHandle;symbolnumber:longint):Pointer;
procedure UnloadDXE    (var handle:DXEHandle);

implementation

TYPE pDXERecord =^DXERecord;
     DXERecord= Record
         DXEMagic     : Cardinal; {Same as file, used to detect corruption}
         Datasize     : Cardinal; {Size DXE data loaded}
         Data         : pchar;    {DXE data pointer}
         Symbol       : pointer;  {The Symbol}
         end;

function LoadDXE(filename : string) : pointer;
{
  Copyright (C) 1995 Charles Sandmann (sandmann@clio.rice.edu)
  translated to Free Pascal by Pierre Muller
}
type
  { to avoid range check problems }
  pointer_array = array[0..maxlongint] of pointer;
  tpa = ^pointer_array;
  plongint = ^longint;
  pCardinal = ^Cardinal;
  ppointer = ^pointer;

var
  dh     : dxe_header;
  data   : pchar;
  f      : file;
  relocs : tpa;
  i      : longint;
  addr   : pCardinal;
  handle : ^DXERecord;

begin
   LoadDXE:=nil;
{ open the file }
   assign(f,filename);
{$I-}
   reset(f,1);
{$I+}
   { quit if no file !! }
   if ioresult<>0 then
     exit;
{ load the header }
   blockread(f,dh,sizeof(dxe_header),i);
   if (i<>sizeof(dxe_header)) or (dh.magic<>DXE_MAGIC) then
     begin
        close(f);
        exit;
     end;
{ get memory for code }
   getmem(data,dh.element_size);
   if data=nil then
     exit;
{ get memory for relocations }
   getmem(relocs,dh.nrelocs*sizeof(pointer));
   if relocs=nil then
     begin
        freemem(data,dh.element_size);
        exit;
     end;
{Create handle}
  New(Handle);
  Handle^.DXEMagic:=DXE_Magic;
  Handle^.Data:=Data;
  Handle^.Datasize:=dh.element_size;

{ copy code }
   blockread(f,data^,dh.element_size);
   blockread(f,relocs^,dh.nrelocs*sizeof(pointer));
   close(f);
{ relocate internal references }
   for i:=0 to dh.nrelocs-1 do
     begin
        Cardinal(addr):=Cardinal(data)+Cardinal(relocs^[i]);
        addr^:=addr^+Cardinal(data);
     end;
   Freemem(relocs,dh.nrelocs*sizeof(Pointer));
   Handle^.symbol:=pointer( dh.symbol_offset + Cardinal(data));
   LoadDXE:=DXEHandle(Handle);
end;

function  GetDXESymbol (Handle:DXEHandle;symbolnumber:longint):Pointer;

begin
 If (pDXERecord(Handle)=NIL) Or (pDXERecord(Handle)^.DXEMagic<>DXE_Magic) Then
  Exit(NIL);
 If symbolnumber<>0 Then    {Multi symbol DXE not suppored yet}
  Exit(NIl);
 GetDXESymbol:=PDXERecord(Handle)^.symbol;
end;

procedure UnloadDXE    (var handle:DXEHandle);

begin
 If (pDXERecord(Handle)=NIL) Or (pDXERecord(Handle)^.DXEMagic<>DXE_Magic) Then
  Exit;
 Freemem(pDXERecord(Handle)^.Data,PDXERecord(Handle)^.datasize);
 Dispose(pDXERecord(Handle));
 Handle:=NIL;
end;

end.
{
  $Log: dxeload.pp,v $
  Revision 1.3  2000/12/16 15:57:52  jonas
    * avoid the longint + Cardinal to int64 conversion (merged Pierre's patch)

  Revision 1.2  2000/07/13 11:33:40  michael
  + removed logs

}
