{/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Margo Seltzer.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)ndbm.h	8.1 (Berkeley) 6/2/93
 }

const
{ Map dbm interface onto db(3). }
	DBM_RDONLY	=O_RDONLY;

{ Flags to dbm_store(). }
	DBM_INSERT      =0;
	DBM_REPLACE     =1;

{
 * The db(3) support for ndbm always appends this suffix to the
 * file name to avoid overwriting the user's original database.
 }
 
	DBM_SUFFIX	='.db';

type	datum		= record
			    dptr   : pchar;
			    dsize  : cint;
			   end;

	pDBM		= ^DBM;
	DBM 		= DB;
	
	
// #define	dbm_pagfno(a)	DBM_PAGFNO_NOT_AVAILABLE

function dbm_clearerr(var arg1 : DBM):cint; cdecl; external;
procedure dbm_close  (var arg1 : DBM); cdecl;  external;
function dbm_delete  (var arg1 : DBM;Data :Datum):cint; cdecl;  external;
function dbm_error   (var arg1 : DBM):cint; cdecl;  external;
function dbm_fetch   (var arg1 : DBM;arg2: Datum):Datum; cdecl;  external;
function dbm_firstkey(var arg1 : DBM):Datum; cdecl;  external;
function dbm_forder  (var arg1 : DBM;arg2:Datum):Long; cdecl;  external;
function dbm_nextkey (var arg1 : DBM):Datum; cdecl;  external;
function dbm_open    (name : pchar;arg2,arg3:cint):pDBM; cdecl;  external;
function dbm_store   (var arg1 : DBM;arg2:Datum;arg3:Datum;arg4:cint):cint; cdecl;  external;
function dbm_dirfno  (var arg1: DBM):cint; cdecl;  external;

{
int	 dbm_clearerr __P((DBM *));
void	 dbm_close __P((DBM *));
int	 dbm_delete __P((DBM *, datum));
int	 dbm_error __P((DBM *));
datum	 dbm_fetch __P((DBM *, datum));
datum	 dbm_firstkey __P((DBM *));
long	 dbm_forder __P((DBM *, datum));
datum	 dbm_nextkey __P((DBM *));
DBM	*dbm_open __P((const char *, int, int));
int	 dbm_store __P((DBM *, datum, datum, int));
int	 dbm_dirfno __P((DBM *));
}