{
 * Copyright (c) 1990, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)db.h	8.7 (Berkeley) 6/16/94
}

{$packrecords C}
// include <sys/types.h>
// include <sys/cdefs.h>
// include <limits.h>


const
	RET_ERROR	=-1;		{Return values. }
	RET_SUCCESS	=0;
	RET_SPECIAL	=1;

	MAX_PAGE_NUMBER	=$ffffffff;	{ >= # of pages in a file }
	MAX_PAGE_OFFSET	=65535;		{ >= # of bytes in a page }
	MAX_REC_NUMBER	=$ffffffff;	{ >= # of records in a tree }

type 	indx_t		= uint16;
	pgno_t		= uint32;
	recno_t		= uint32;

	DBT 		= record
			   Data	: Pointer; { Data}
 			   _size: size_t;  { Data length}
			   end;

CONST
 	
{ Routine flags. }
	R_CURSOR	=1;		{ del, put, seq }
	__R_UNUSED	=2;		{ UNUSED }
	R_FIRST		=3;		{ seq }
	R_IAFTER	=4;		{ put (RECNO) }
	R_IBEFORE	=5;		{ put (RECNO) }
	R_LAST		=6;		{ seq (BTREE, RECNO) }
	R_NEXT		=7;		{ seq }
	R_NOOVERWRITE	=8;		{ put }
	R_PREV		=9;		{ seq (BTREE, RECNO) }
	R_SETCURSOR	=10;		{ put (RECNO) }
	R_RECNOSYNC	=11;		{ sync (RECNO) }

{ am not sure about this}

// typedef enum { DB_BTREE, DB_HASH, DB_RECNO } DBTYPE;

type DBTYPE=(DB_BTREE,DB_HASH,DB_RECNO);

CONST

{
 * !!!
 * The following flags are included in the dbopen(3) call as part of the
 * open(2) flags.  In order to avoid conflicts with the open flags, start
 * at the top of the 16 or 32-bit number space and work our way down.  If
 * the open flags were significantly expanded in the future, it could be
 * a problem.  Wish I'd left another flags word in the dbopen call.
 *
 * !!!
 * None of this stuff is implemented yet.  The only reason that it's here
 * is so that the access methods can skip copying the key/data pair when
 * the DB_LOCK flag isn't set.
 }
 	DB_LOCK		=$20000000;	{ Do locking. }
	DB_SHMEM	=$40000000;	{ Use shared memory. }
	DB_TXN		=$80000000;	{ Do transactions. }

	{ Access method description structure. }

TYPE	pDB		= ^DB;
    	pDBT		= ^DBT;
    	
	tcloseproc	= function(arg1: pDB):cint; cdecl;
	tdelproc	= function(arg1 : pDB; arg2:pDBT; c:cardinal):cint; cdecl;
	tgetproc	= function(arg1 : pDB; arg2:pDBT; arg3: pDBT;c:cardinal):cint; cdecl;
	tputproc	= function(arg1 : pDB; arg2: pDBT; arg3:pDBT;c:cardinal):cint; cdecl;
	tseqproc	= function(arg1 : pDB; arg2 ,arg3 : pDBT; c:cardinal):cint; cdecl;
	tsyncproc	= function(arg1 : pDB; c:cardinal):cint; cdecl;
	tfdproc		= function(arg1 : pDB):cint; cdecl;

	DB		= record
			    _type	: DBTYPE;   { Underlying db type. }
			    close	: tcloseproc;
			    del		: tdelproc;
			    get		: tgetproc;
			    put		: tputproc;
			    seq		: tseqproc;
			    sync	: tsyncproc;
			    internal	: pointer;   { Access method private. }
			    fd		: tfdproc;
			    end;

CONST 

	BTREEMAGIC	=$053162;
	BTREEVERSION	=3;

{flags below}
	R_DUP		=$1;	{ duplicate keys }

type 
	tcompareproc    = function (const arg1 : DBT;const arg2 : DBT):cint; cdecl;
	tprefixproc	= function (const arg1 : DBT;const arg2 : DBT):size_t; cdecl;
	
	pBTREEINFO	= ^BTREEINFO;
	BTREEINFO	= RECORD
			   flags 	: ulong;
			   cachesize	: uint;	 	{ bytes to cache }
			   maxkeypage	: cint;	{ maximum keys per page }
			   minkeypage	: cint;	{ minimum keys per page }
			   psize	: uint;		{ page size }
			   compare	: tcompareproc;	{ comparison function }
			   prefix	: tprefixproc;  { prefix function }
			   lorder	: cint;	{ byte order }
			   END;			   

CONST
	HASHMAGIC	=$061561;
	HASHVERSION	=$2;

TYPE
	THashProc	= function (arg1 :pointer;arg2:size_t):cardinal; cdecl;

	{ Structure used to pass parameters to the hashing routines. }

	pHASHINFO	= ^HASHINFO;
	HASHINFO	= record
			    bsize 	: uint;		{ bucket size }
			    ffactor	: uint;		{ fill factor }
			    nelem	: uint;		{ number of elements }
			    cachesize	: uint; 	{ bytes to cache }
			    hash	: THashProc;	{ hash function }	
			    lorder	: cint;	{ byte order}
			   end;

const
 	R_FIXEDLEN	=$1;	{ fixed-length records }
	R_NOKEY		=$2;	{ key not required }
	R_SNAPSHOT	=$4;	{ snapshot the input }

{ Structure used to pass parameters to the record routines. }

type	
	pRECNOINFO	= ^RECNOINFO;
	RECNOINFO	= record
			    flags 	: ulong;
			    cachesize	: uint;		{ bytes to cache }
			    psize	: uint;		{ page size }
			    lorder	: cint;	{ byte order }
			    reclen	: size_t;	{ record length (fixed-length records) }
			    bval	: uchar;	{ delimiting byte (variable-length records }
			    bfname	: pchar;	{ btree file name }
			    end;

// ifdef __DBINTERFACE_PRIVATE
{
 * Little endian <==> big endian 32-bit swap macros.
 *	M_32_SWAP	swap a memory location
 *	P_32_SWAP	swap a referenced memory location
 *	P_32_COPY	swap from one location to another
 }
 

function  dbopen    (arg1 : pchar;arg2:cint;arg3:cint;arg4:DBTYPE;arg5:pointer):pDB; cdecl; external;
function  bt_open   (arg1 : pchar;arg2:cint;arg3:cint; const arg4 : BTREEINFO;arg5:cint): pDB;  cdecl; external;
function  hash_open (arg1 : pchar;arg2:cint;arg3:cint; const arg4 : HASHINFO ;arg5:cint): pDB; cdecl; external;
function  rec_open  (arg1 : pchar;arg2:cint;arg3:cint; const arg4 : RECNOINFO;arg5:cint): pDB; cdecl; external;
procedure dbpanic   (var dbp : DB); cdecl; external;


//DB    *dbopen __P((const char *, int, int, DBTYPE, const void *));
//DB	*__bt_open __P((const char *, int, int, const BTREEINFO *, int));
//DB	*__hash_open __P((const char *, int, int, const HASHINFO *, int));
//DB	*__rec_open __P((const char *, int, int, const RECNOINFO *, int));
//void	 __dbpanic __P((DB *dbp));

